within OpenPBS.VehicleModels;
model VerticalForces
   constant Modelica.SIunits.Acceleration g=Modelica.Constants.g_n;
  parameter OpenPBS.VehicleParameters.Base.VehicleModel paramSet;
  parameter Integer nu=paramSet.nu "Number of units";
  parameter Integer na=paramSet.na "Max number of axles per unit";
  parameter Modelica.SIunits.Force[nu,na] Fz=paramSet.Fz;
  parameter Boolean[nu-1] rfc=paramSet.rfc "Defines roll-free coupling";
  parameter Modelica.SIunits.Mass[nu] mk=paramSet.mk "Kerb masses";
  parameter Modelica.SIunits.Length[nu,na] L=paramSet.L
    "Axle positions relative first axle of each unit";
  parameter Modelica.SIunits.Length[nu] A=paramSet.A
    "Front coupling position relative first axle";
  parameter Modelica.SIunits.Length[nu] B=paramSet.B
    "Rear coupling position relative first axle";
  parameter Integer[nu,na] axlegroups=paramSet.axlegroups annotation(Evaluate=true);


  Modelica.SIunits.Length[nu,na] Lcog = L-matrix(X)*ones(1,na)
    "Axle positions relative c.g.";

  Modelica.SIunits.Length[nu] Bcog = B-X;
  Modelica.SIunits.Length[nu] Acog = A-X;
  Modelica.SIunits.Force[nu-1] Fcz "Vertical force at couplings";
  Modelica.SIunits.Mass[nu] ml "Load masses";
  Modelica.SIunits.Mass[nu] m;
  Modelica.SIunits.Length[nu] X;

equation

// Calculate load masses ml
  for i in 1:nu loop
    if i==1 and rfc[i]==true then
      ml[i]+mk[i]=sum(Fz[i,:])/g "Rigid Truck";
      if rfc[i+1]==false then
        ml[i+1]=0 "Dolly";
        ml[i+2]+sum(mk[i+1:i+2])=sum(Fz[i+1:i+2,:])/g "Semitrailer";
//        "Nordic combination"
      elseif rfc[i+1]==true then
        ml[i+1]+mk[i+1]=sum(Fz[i+1,:])/g "CAT";
        ml[i+2]+mk[i+2]=sum(Fz[i+2,:])/g "CAT";
//        "DoubleCAT"
      else
        ml[i]=0;
      end if;
    elseif i==1 and rfc[i]==false then
      ml[i]=0 "Tractor";
      if rfc[i+1]==false then
        ml[i+1]+sum(mk)+ml[i+2]=sum(Fz)/g "Link-trailer";
        ml[i+2]=(42000-mk[i+2])/(15600-1500)*(Fcz[i+1]/g-1500) "Based on assumptions, that when semi is empty, the coupling force is 1500*g and when fully loaded, coupling force is 15600*g. Max gross weight for 3-axle semitrailer: 42000 kg";
//         "B-double"
      elseif rfc[i+1]==true and nu==3 then
        ml[i+1]+sum(mk[i:i+1])=sum(Fz[i:i+1,:])/g "Semitrailer";
        ml[i+2]+mk[i+2]=sum(Fz[i+2,:])/g "CAT";
//         "Tractor-semitrailer-CAT"
      elseif rfc[i+1]==true and rfc[i+2]==false then
        ml[i+1]+sum(mk[i:i+1])=sum(Fz[i:i+1,:])/g "Semitrailer";
        ml[i+2]=0 "Dolly";
        ml[i+3]+sum(mk[i+2:i+3])=sum(Fz[i+2:i+3,:])/g "Semitrailer";
//        "A-double"
      elseif nu==2 then
        ml[2]+sum(mk)=sum(Fz)/g "Semitrailer";
      else
        ml[i]=0;
      end if;
    end if;
  end for;


  for i in 1:nu loop

// Calculate total masses m
     m[i]=mk[i]+ml[i];

// Solve Fcz and X
//      if i<nu then
//         Fcz[i]-sum(Fz[i,:])-Fcz[i-1]=-(ml[i]+mk[i])*Modelica.Constants.g_n;
//         (sum(Fz[i,1:na].*L[i,1:na])+Fcz[i-1].*A[i]-Fcz[i].*B[i])/(m[i]*Modelica.Constants.g_n)=X[i];
//      else
//         (sum(Fz[i,1:na].*L[i,1:na])+Fcz[i-1].*A[i])/(m[i]*Modelica.Constants.g_n)=X[i];
//      end if;

     if i ==1 then
        Fcz[i]-sum(Fz[i,:])=-(ml[i]+mk[i])*Modelica.Constants.g_n;
        (sum(Fz[i,1:na].*L[i,1:na])-Fcz[i].*B[i])/(m[i]*Modelica.Constants.g_n)=X[i];
     elseif i>1 and i<nu then
        Fcz[i]-sum(Fz[i,:])-Fcz[i-1]=-(ml[i]+mk[i])*Modelica.Constants.g_n;
        (sum(Fz[i,1:na].*L[i,1:na])+Fcz[i-1].*A[i]-Fcz[i].*B[i])/(m[i]*Modelica.Constants.g_n)=X[i];
     else
        (sum(Fz[i,1:na].*L[i,1:na])+Fcz[i-1].*A[i])/(m[i]*Modelica.Constants.g_n)=X[i];
     end if;

  end for;

 annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)));
end VerticalForces;
