within OpenPBS.VehicleParameters.Base;
record VehicleModel "Base vehicle model parameter set"

  extends Modelica.Icons.Record;
  parameter Integer nu=2 
    "Number of units";
  parameter Integer na=3 
    "Max number of axles per unit";
  parameter Integer vehicletype=5;
  parameter Modelica.SIunits.Position[nu,na] L=[1,1,1; 1,1,1] 
    "All axle longitudinal positions rearward from first axle of each unit";
  parameter Modelica.SIunits.Length[nu,na] W=[1,1,1; 1,1,1] 
    "Track width per axle";
//  parameter Modelica.SIunits.Position[nu] X={-1,-1} 
//    "C.g. longitudinal position relative first axle";
  parameter Modelica.SIunits.Force[nu,na] Fz=[1,1,1;1,1,1] "Vertical axle forces" ;
  parameter Modelica.SIunits.Position[nu] h={1,1} 
    "C.g. height over ground";
  parameter Modelica.SIunits.Position[nu] A={1,1} 
    "Front coupling position relative first axle";
  parameter Modelica.SIunits.Length[nu] B={-2,-2} 
    "Rear coupling position relative first axle";
  parameter Boolean[nu,na] driven=[false,true,false; false,false,false]
    "True for each driven axle";
  parameter Real[nu,na] CCy0=5.5*[1,1,1; 1,1,1]
    "Cornering coefficient per axle";
//  parameter Modelica.SIunits.Mass[nu] m={1,1} 
//    "Masses";
  parameter Modelica.SIunits.Mass[nu] mk={1,1} 
    "Kerb masses";
  parameter Modelica.SIunits.Inertia[nu] Iz={10000,10000} 
    "Inertias";
  parameter Integer[nu,na] axlegroups=[1,2,2; 1,1,1]
    "Vehicle axlegroups";
  parameter Modelica.SIunits.Length[nu] FOH={1,1} 
    "Front hang define from the front axle of each unit.";
  parameter Modelica.SIunits.Length[nu] ROH={-5,-5} 
    "Rear hang define from the front axle of each unit.";
  parameter Real drag_coefficient=0.5
    "Drag coefficient";
  parameter Modelica.SIunits.Area frontal_area=4
    "Frontal Area";
  parameter Real rolling_resistance_coefficient=0.004 
    "Rolling resistance force as a function of vertical force";
  parameter Modelica.SIunits.Power max_engine_power=550000
    "Max engine power";
  parameter Modelica.SIunits.Force max_thrust_force_vx0=175000
    "Max trust force";
  parameter Real[nu, na] CZT = [2.45e6,2.86e6,2.86e6;2.36e6, 2.36e6, 2.36e6] " Tyre normal stiffness" ;
  parameter Real[nu, na] CYT = 2e5*[1,1,1;1,1,1] " Tyre lateral stiffness " ;
  parameter Modelica.SIunits.Length[nu, na] We=[1,1,1;1,1,1] " Effective track width ";
  parameter Boolean[nu-1] rfc={false} "Defines roll-free couplings";
  
  annotation (
    Icon(coordinateSystem(preserveAspectRatio=false)),
    Diagram(coordinateSystem(preserveAspectRatio=false)),
    Documentation(info="<html>

</html>"));
end VehicleModel;
