within OpenPBS.VehicleParameters.Vehicles;
record Semi_RollDynamics_NonLinTyre = OpenPBS.VehicleParameters.Base.VehicleModelRollDynamicsNonLinTyre (
    nu = 2 "Number of units",
    na = 3 "Max number of axles per unit",
    axlegroups = [1, 2, 2 ; 1, 1, 1] "Vehicle axlegroups",
    driven=[false, true, true ; false, false, false] "Defines driven axles",
    m = {9231.0, 31000.0} "Masses of units",
    Iz = {4.4483e4,4.6524e5} "Inertia of unit in Yaw-plane",
    L = [0.0, -3.4, -4.77 ; 0.0, -1.3, -2.6] "Axle positions relative to units first axle",
    A = {0.0, 6.8}"Units front coupling position relative to first axle of unit",
    B = {-3.775, -3.7}"Units rear coupling position relative to first axle of unit",
    X = {-1.8641, 1.5461}"Centre of gravity position relative to first axle of unit",
    h = {0.9704, 1.8987} "Units centre of gravity height",
    hRC = {0.681, 0.5450} "Units Roll Centre height",
    hC = {1.0} "Coupling height between units",
    ks = [4.6388e5, 4.8284e5, 4.8284e5; 1.5e6, 1.5e6, 1.5e6] "Suspension roll stiffness",
    cs = [14119, 16981, 16891; 30000, 30000, 30000] "Suspension roll dampening",
    Kcr = {1e9} "Coupling roll stiffness",
    Ccr = {0} "Coupling roll dampening",
    Ix = {4700.2, 2.8429e4} "Roll inertia",
    W=[2.09, 1.85, 1.85; 2.05, 2.05, 2.05] "Track Width",
    FOH={0.5,7.15},
    ROH={-4.8,-3} "A-double with 6x4 tractor",
    Lr =0.4 .*[1,1,1;1,1,1] "Relaxation length",
    FZT0=25000 .*[1,1,1;1,1,1] "Tyre static load on each indicidual axle",
    uy0=0.8.*[1,1,1;1,1,1] "Maximum lateral force coefficient at nominal vertical tyre force",
    ugy=-0.2.*[1,1,1;1,1,1] "Maximum lateral force gradient",
    u2=0.8.*[1,1,1;1,1,1] "Slide friction ratio",
    CCy0=7.5.*[1,1,1;1,1,1] "Tyre cornering coefficient on each individual axle",
    ccgy=-0.1.*[1,1,1;1,1,1] "Maximum cornering coefficient gradient ");
